/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers.core;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.AbstractCrafting;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.requestsystem.requesters.IBuildingBasedRequester;
import com.minecolonies.coremod.colony.requestsystem.resolvers.core.AbstractRequestResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCraftingProductionResolver<C extends AbstractCrafting>
extends AbstractRequestResolver<C>
implements IBuildingBasedRequester {
    private final Class<C> cClass;

    public AbstractCraftingProductionResolver(@NotNull ILocation location, @NotNull IToken<?> token, Class<C> cClass) {
        super(location, token);
        this.cClass = cClass;
    }

    @Override
    public TypeToken<? extends C> getRequestType() {
        return TypeToken.of(this.cClass);
    }

    @Override
    public Optional<IRequester> getBuilding(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
        if (!manager.getColony().getWorld().field_72995_K) {
            return Optional.ofNullable(manager.getColony().getRequesterBuildingForPosition(this.getLocation().getInDimensionLocation()));
        }
        return Optional.empty();
    }

    @Override
    public boolean canResolveRequest(@NotNull IRequestManager manager, IRequest<? extends C> requestToCheck) {
        if (!manager.getColony().getWorld().field_72995_K) {
            ILocation requesterLocation = requestToCheck.getRequester().getLocation();
            return requesterLocation.equals(this.getLocation());
        }
        return false;
    }

    @Override
    @Nullable
    public List<IToken<?>> attemptResolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<? extends C> request) {
        AbstractBuilding building = this.getBuilding(manager, (IToken<?>)request.getId()).map(r -> (AbstractBuilding)r).get();
        return this.attemptResolveForBuilding(manager, request, building);
    }

    @Nullable
    public List<IToken<?>> attemptResolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends C> request, @NotNull AbstractBuilding building) {
        AbstractBuildingWorker buildingWorker = (AbstractBuildingWorker)building;
        return this.attemptResolveForBuildingAndStack(manager, buildingWorker, ((AbstractCrafting)request.getRequest()).getStack(), ((AbstractCrafting)request.getRequest()).getCount(), ((AbstractCrafting)request.getRequest()).getMinCount(), ((AbstractCrafting)request.getRequest()).getRecipeID());
    }

    @Nullable
    protected List<IToken<?>> attemptResolveForBuildingAndStack(@NotNull IRequestManager manager, @NotNull AbstractBuildingWorker building, ItemStack stack, int count, int minCount, IToken<?> recipeId) {
        ICraftingBuildingModule module = building.getCraftingModuleForRecipe(recipeId);
        if (module == null) {
            return null;
        }
        if (!this.canBuildingCraftStack(manager, building, stack)) {
            return null;
        }
        IRecipeStorage fullfillableCrafting = module.getFirstFulfillableRecipe(itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack), count, true);
        if (fullfillableCrafting != null) {
            return ImmutableList.of();
        }
        IRecipeStorage craftableCrafting = module.getFirstRecipe(stack);
        if (craftableCrafting == null) {
            return null;
        }
        return this.createRequestsForRecipe(manager, building, count, minCount, craftableCrafting);
    }

    protected boolean canBuildingCraftStack(@NotNull IRequestManager manager, @NotNull AbstractBuildingWorker building, @NotNull ItemStack stack) {
        return true;
    }

    @Nullable
    protected List<IToken<?>> createRequestsForRecipe(@NotNull IRequestManager manager, @NotNull AbstractBuildingWorker building, int count, int minCount, @NotNull IRecipeStorage storage) {
        ArrayList materialRequests = new ArrayList();
        for (ItemStorage ingredient : storage.getCleanedInput()) {
            if (ItemStackUtils.isEmpty(ingredient.getItemStack()).booleanValue()) continue;
            ItemStack craftingHelperStack = ingredient.getItemStack().func_77946_l();
            ItemStack container = ingredient.getItem().getContainerItem(ingredient.getItemStack());
            if (!storage.getSecondaryOutputs().isEmpty() && ItemStackUtils.compareItemStackListIgnoreStackSize(storage.getSecondaryOutputs(), craftingHelperStack, false, true)) {
                materialRequests.add(this.createNewRequestForStack(manager, craftingHelperStack, ingredient.getAmount(), ingredient.getAmount(), false));
                continue;
            }
            if (!storage.getCraftingTools().isEmpty() && ItemStackUtils.compareItemStackListIgnoreStackSize(storage.getCraftingTools(), craftingHelperStack, false, true)) {
                if (InventoryUtils.getItemCountInProvider((ICapabilityProvider)building, item -> ItemStackUtils.compareItemStacksIgnoreStackSize(item, craftingHelperStack, false, true)) > ingredient.getAmount()) continue;
                int requiredForDurability = (int)Math.ceil((double)count / (double)ingredient.getRemainingDurablityValue());
                materialRequests.add(this.createNewRequestForStack(manager, craftingHelperStack, requiredForDurability, requiredForDurability, false));
                continue;
            }
            if (!ItemStackUtils.isEmpty(container).booleanValue() && ItemStackUtils.compareItemStacksIgnoreStackSize(container, craftingHelperStack, false, true)) {
                materialRequests.add(this.createNewRequestForStack(manager, craftingHelperStack, ingredient.getAmount(), ingredient.getAmount(), false));
                continue;
            }
            materialRequests.add(this.createNewRequestForStack(manager, craftingHelperStack, ingredient.getAmount() * count, ingredient.getAmount() * minCount, true));
        }
        return materialRequests;
    }

    @Nullable
    protected IToken<?> createNewRequestForStack(@NotNull IRequestManager manager, ItemStack stack, int count, int minCount, boolean matchMeta) {
        Stack stackRequest = new Stack(stack, matchMeta, true, false, ItemStack.field_190927_a, count, minCount);
        return manager.createRequest(this, stackRequest);
    }

    @Override
    public void resolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<? extends C> request) {
        AbstractBuilding building = this.getBuilding(manager, (IToken<?>)request.getId()).map(r -> (AbstractBuilding)r).get();
        this.resolveForBuilding(manager, request, building);
    }

    protected void onAssignedToThisResolverForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends C> request, boolean simulation, @NotNull AbstractBuilding building) {
    }

    @Override
    public void onRequestAssigned(@NotNull IRequestManager manager, @NotNull IRequest<? extends C> request, boolean simulation) {
        AbstractBuilding building = this.getBuilding(manager, (IToken<?>)request.getId()).map(r -> (AbstractBuilding)r).get();
        this.onAssignedToThisResolverForBuilding(manager, request, simulation, building);
    }

    public void resolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends C> request, @NotNull AbstractBuilding building) {
        AbstractBuildingWorker buildingWorker = (AbstractBuildingWorker)building;
        ICraftingBuildingModule module = buildingWorker.getCraftingModuleForRecipe((IToken<?>)request.getId());
        if (module == null) {
            manager.updateRequestState((IToken<?>)request.getId(), RequestState.FAILED);
            return;
        }
        IRecipeStorage storage = module.getFirstFulfillableRecipe(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, ((AbstractCrafting)request.getRequest()).getStack()), ((AbstractCrafting)request.getRequest()).getCount(), false);
        if (storage == null) {
            manager.updateRequestState((IToken<?>)request.getId(), RequestState.FAILED);
            return;
        }
        int craftingCount = CraftingUtils.calculateMaxCraftingCount(((AbstractCrafting)request.getRequest()).getCount(), storage);
        for (int i = 0; i < craftingCount; ++i) {
            module.fullFillRecipe(storage);
        }
        manager.updateRequestState((IToken<?>)request.getId(), RequestState.RESOLVED);
    }
}

